
<?php
session_start();
require_once '../db_connect.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit();
}

// ব্যালেন্স বা পাসওয়ার্ড আপডেট করার লজিক
if (isset($_POST['update_user'])) {
    $uid = $_POST['user_id'];
    $new_balance = $_POST['balance'];
    $new_pass = $_POST['password'];

    // পাসওয়ার্ড যদি খালি না থাকে তবেই আপডেট হবে
    if (!empty($new_pass)) {
        $hashed_pass = password_hash($new_pass, PASSWORD_DEFAULT);
        $conn->query("UPDATE users SET balance='$new_balance', password='$hashed_pass' WHERE id='$uid'");
    } else {
        $conn->query("UPDATE users SET balance='$new_balance' WHERE id='$uid'");
    }
    echo "<script>alert('User Updated Successfully!');</script>";
}

// ইউজার ডিলিট করা
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $conn->query("DELETE FROM users WHERE id='$id'");
    header("Location: users.php");
}

// সকল ইউজার ডাটা আনা
$users = $conn->query("SELECT * FROM users ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Users</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: #1E2129; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #333; color: #ddd; }
        th { background: #000; color: #F5C300; }
        .action-btn { padding: 5px 10px; border-radius: 5px; text-decoration: none; font-size: 12px; font-weight: bold; }
        .edit-btn { background: #007bff; color: white; border: none; cursor: pointer; }
        .del-btn { background: #ff4d4d; color: white; }
        
        /* Modal Style */
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); justify-content: center; align-items: center; }
        .modal-content { background: #1E2129; padding: 20px; border-radius: 10px; width: 300px; border: 1px solid #F5C300; }
        .modal input { width: 90%; padding: 8px; margin: 10px 0; background: #000; color: #fff; border: 1px solid #444; }
    </style>
</head>
<body>

    <!-- সাইডবার ইনক্লুড -->
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php" class="active"><i class="fas fa-users"></i> Manage Users</a></li>
            <li><a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a></li>
            <li><a href="withdrawals.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a></li>
            <li><a href="logout.php" style="color: #ff4d4d;"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="header"><h2>All Registered Users</h2></div>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Phone</th>
                    <th>Username</th>
                    <th>UID</th>
                    <th>Balance</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $users->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo $row['phone']; ?></td>
                    <td><?php echo $row['username']; ?></td>
                    <td><?php echo $row['u_id']; ?></td>
                    <td>৳ <?php echo $row['balance']; ?></td>
                    <td>
                        <button class="action-btn edit-btn" onclick="openModal(<?php echo $row['id']; ?>, '<?php echo $row['balance']; ?>')">Edit</button>
                        <a href="users.php?delete=<?php echo $row['id']; ?>" class="action-btn del-btn" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- Edit User Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <h3>Edit User Balance/Pass</h3>
            <form method="POST">
                <input type="hidden" name="user_id" id="modal_uid">
                <label>New Balance:</label>
                <input type="number" name="balance" id="modal_balance" step="0.01" required>
                <label>New Password (Optional):</label>
                <input type="text" name="password" placeholder="Leave empty to keep same">
                <button type="submit" name="update_user" class="action-btn edit-btn" style="width:100%; margin-top:10px;">Update</button>
                <button type="button" onclick="document.getElementById('editModal').style.display='none'" class="action-btn del-btn" style="width:100%; margin-top:5px;">Cancel</button>
            </form>
        </div>
    </div>

    <script>
        function openModal(id, balance) {
            document.getElementById('editModal').style.display = 'flex';
            document.getElementById('modal_uid').value = id;
            document.getElementById('modal_balance').value = balance;
        }
    </script>
</body>
</html>
